<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * Department
 *
 * @ORM\Table(name="departments")
 * @ORM\Entity
 *
 * @ExclusionPolicy("all")
 */
class Department
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="type_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails","departmentList"})
     */
    private $typeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="market_segment_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    private $marketSegmentId;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    private $name;

    /**
     * @var integer
     *
     * @ORM\Column(name="sequence", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    private $sequence;

    /**
     * @var text $restrictions
     *
     * @ORM\Column(name="restrictions", type="text")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "simpleList"})
     */
    private $restrictions = '';

    /**
     * @ORM\OneToMany(targetEntity="DepartmentAllegroCategoryItem", mappedBy="department")
     */
    protected $items;

    /**
     * @ORM\ManyToOne(targetEntity="DepartmentType", inversedBy="departments")
     * @ORM\JoinColumn(name="type_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails","departmentList"})
     */
    protected $type;


    /**
     * @ORM\ManyToOne(targetEntity="MarketSegment", inversedBy="departments")
     * @ORM\JoinColumn(name="market_segment_id", referencedColumnName="id")
     */
    protected $marketSegment;


    /**
     * @ORM\OneToMany(targetEntity="CompanyEmployee", mappedBy="department")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails"})
     * @Accessor(getter="getEmployees")
     * @SerializedName("employees")
     * @Type("array")
     */
    protected $companyEmployees;



    public function getEmployees()
    {
        $array = array();

        foreach($this->getCompanyEmployees() as $CompanyEmployee)
        {
            $array[] = $CompanyEmployee->getEmployee();
        }

        return $array;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->companyEmployees = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set typeId
     *
     * @param integer $typeId
     * @return Department
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
    
        return $this;
    }

    /**
     * Get typeId
     *
     * @return integer 
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * Set marketSegmentId
     *
     * @param integer $marketSegmentId
     * @return Department
     */
    public function setMarketSegmentId($marketSegmentId)
    {
        $this->marketSegmentId = $marketSegmentId;
    
        return $this;
    }

    /**
     * Get marketSegmentId
     *
     * @return integer 
     */
    public function getMarketSegmentId()
    {
        return $this->marketSegmentId;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Department
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set sequence
     *
     * @param integer $sequence
     * @return Department
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
    
        return $this;
    }

    /**
     * Get sequence
     *
     * @return integer 
     */
    public function getSequence()
    {
        return $this->sequence;
    }

    /**
     * Set type
     *
     * @param \VM\ApiBundle\Entity\DepartmentType $type
     * @return Department
     */
    public function setType(\VM\ApiBundle\Entity\DepartmentType $type = null)
    {
        $this->type = $type;
    
        return $this;
    }

    /**
     * Get type
     *
     * @return \VM\ApiBundle\Entity\DepartmentType 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set marketSegment
     *
     * @param \VM\ApiBundle\Entity\MarketSegment $marketSegment
     * @return Department
     */
    public function setMarketSegment(\VM\ApiBundle\Entity\MarketSegment $marketSegment = null)
    {
        $this->marketSegment = $marketSegment;
    
        return $this;
    }

    /**
     * Get marketSegment
     *
     * @return \VM\ApiBundle\Entity\MarketSegment 
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }

    /**
     * Add companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     * @return Department
     */
    public function addCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees[] = $companyEmployees;
    
        return $this;
    }

    /**
     * Remove companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     */
    public function removeCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees->removeElement($companyEmployees);
    }

    /**
     * Get companyEmployees
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyEmployees()
    {
        return $this->companyEmployees;
    }

    /**
     * Set restrictions
     *
     * @param string $restrictions
     * @return Department
     */
    public function setRestrictions($restrictions)
    {
        $this->restrictions = $restrictions;
    
        return $this;
    }

    /**
     * Get restrictions
     *
     * @return string 
     */
    public function getRestrictions()
    {
        return $this->restrictions;
    }

    /**
     * Add items
     *
     * @param \VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $items
     * @return Department
     */
    public function addItem(\VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $items)
    {
        $this->items[] = $items;
    
        return $this;
    }

    /**
     * Remove items
     *
     * @param \VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $items
     */
    public function removeItem(\VM\ApiBundle\Entity\DepartmentAllegroCategoryItem $items)
    {
        $this->items->removeElement($items);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getItems()
    {
        return $this->items;
    }
}